#include "stdinc.h"
#include "pce.h"

#ifdef PALWORD
PALFMT PAL_CALC(int col) { return (PALFMT)((((((col)>>2)&7)*36)/8)| (((((col)>>5)*36)/8)<<5) | (((((col)&3)*84)/8)<<10)); }
#else//PALWORD
PALFMT PAL_CALC(int col) { return col; }
#endif//PALWORD

//-------------------------------------------------------------------
// 
// VCE WRITE ACCESS
// 
//-------------------------------------------------------------------
void VCE_write(word A, byte V)
{
    A = A & 7;
    
    switch(A) {
      case 0: io.vce_cr = V&0x87;            break;
      case 1: /*TRACE("VCE 1, V=%X\n", V);*/ break;
      case 2: io.vce_reg.B.l = V;            break;
      case 3: io.vce_reg.B.h = V&1;          break;
      case 4: io.VCE[io.vce_reg.W].B.l= V;   break;
      case 5: {
          register int i;
          register int n = io.vce_reg.W;
          register byte c;
          
          io.VCE[n].B.h = V;
          c = io.VCE[n].W>>1;
          
          // update palette
          if(n==0)        for(i=  0;i<256;i+=16)  huePal[i]=PAL_CALC((int)c);
          else if(n==256) for(i=256;i<512;i+=16)  huePal[i]=PAL_CALC((int)c);
          else if(n&15)                           huePal[n]=PAL_CALC((int)c);
          
          io.vce_reg.W=(io.vce_reg.W+1)&0x1FF;
      }
        return;
      case 6:	/*TRACE("VCE 6, V=%X\n", V);*/ break;
      case 7:	/*TRACE("VCE 7, V=%X\n", V);*/ break;
    }
    
}

//-------------------------------------------------------------------
// 
// VCE READ ACCESS
// 
//-------------------------------------------------------------------
byte VCE_read(word A)
{
    A = A & 7;

    if(A==4) {
        return io.VCE[io.vce_reg.W].B.l;
    } else
    if(A==5) {
        byte v = io.VCE[io.vce_reg.W].B.h;
        io.vce_reg.W = (io.vce_reg.W+1) & 0x1ff;
        return v;
    }

    return 0;
}

